/****************************************************************************/
/* FILE NAME: flexCAN_test.c                    COPYRIGHT (c) Freescale 2006*/
/*                                                All Rights Reserved     	*/
/* DESCRIPTION:                                                           	*/
/* This performs DSPI communication and sets LEDs when complete.			*/
/*========================================================================	*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               	*/
/* ---   -----------    ----------    ---------------------               	*/
/* 0.1	  D.Paterson	01/Feb/07    Initial Version					  	*/
/****************************************************************************/
#include "mpc5561.h"

extern vuint32_t DSPI_RXQUEUE[2];
extern vuint32_t DSPI_RXQUEUE1[2];

void flexCAN_A_config();
void flexCAN_C_config();
void flexCAN_test(void);

/**************************************************************************/
/* FUNCTION     : flexCAN_test		  								      */
/* PURPOSE      : Transmits data and sets LEDs						 	  */
/**************************************************************************/
void flexCAN_test(void)
{	
	int pass_count = 0;
	
	while (pass_count < 2)
	{
                if(CAN_A.IFRL.B.BUF01I == 1)
                {
		     CAN_A.BUF[0].DATA.W[0] = DSPI_RXQUEUE[0];		//Send data received on DSPIB
		     CAN_A.BUF[0].DATA.W[1] = CAN_A.BUF[1].DATA.W[1];

		     //now clear BUF[1]
		     CAN_A.BUF[1].DATA.W[0] = 0;
		     CAN_A.BUF[1].DATA.W[1] = 0;

		     // Transmit data in CAN_A[0]
		     CAN_A.BUF[0].CS.B.CODE = 0xC;

             //clear flag
             CAN_A.IFRL.B.BUF01I = 1;
		     pass_count++;
		     SIU.GPDO[203].R = 1;							//Set LED
                }

                if(CAN_C.IFRL.B.BUF03I == 1)
                {
		     CAN_C.BUF[2].DATA.W[0] = DSPI_RXQUEUE1[0];		//Send data received on DSPIC
		     CAN_C.BUF[2].DATA.W[1] = CAN_C.BUF[3].DATA.W[1];

		     //now clear BUF[3]
		     CAN_C.BUF[3].DATA.W[0] = 0;
		     CAN_C.BUF[3].DATA.W[1] = 0;

		     // Transmit data in CAN_C[2]
		     CAN_C.BUF[2].CS.B.CODE = 0xC;

             //clear flag
             CAN_C.IFRL.B.BUF03I = 1;
		     pass_count++;
		     SIU.GPDO[204].R = 1;							//Set LED
                }
	}	
}

/**************************************************************************/
/* FUNCTION     : flexCAN_A_config		  								  */
/* PURPOSE      : Configures FlexCAN A & buffers						 */
/**************************************************************************/
void flexCAN_A_config(void){
	
	int i=0;
	int j=0;
	
	/* Turn on CAN_A*/
	CAN_A.MCR.R = 0x1080000F;

	/* Initialize all operating modes for CAN_A*/
	CAN_A.CR.R = 0x0f492002;

	/* Initialize all CAN_A message buffers as inactive */
	CAN_A.BUF[0].CS.B.CODE = 0x8;
	CAN_A.BUF[1].CS.B.CODE = 0x4;

	for (i=4; i<16; i++)
	{
		CAN_A.BUF[i].CS.B.CODE = 0x0;
	}

	/* Set transmit length of CAN_A[0] and CAN_A[2] to 8 bytes */
	CAN_A.BUF[0].CS.B.LENGTH = 0x8;
	CAN_A.BUF[1].CS.B.LENGTH = 0x8;

	/* Set MB IDE, RTR, and IDs for CAN_A */
	CAN_A.BUF[0].CS.B.IDE = 0;
	CAN_A.BUF[1].CS.B.IDE = 0;

	CAN_A.BUF[0].CS.B.RTR = 0;
	CAN_A.BUF[1].CS.B.RTR = 0;

	CAN_A.BUF[0].ID.R = 0x08000000;
	CAN_A.BUF[1].ID.R = 0x10000000;

	CAN_A.RXGMASK.R = 0x1FFFFFFF;
	/* Negate halt bit in MCR to synch with FlexCAN bus */
	CAN_A.MCR.B.HALT = 0;

	CAN_A.BUF[1].DATA.W[0] = 0x00000000;
	CAN_A.BUF[1].DATA.W[1] = 0x00000000;
}

/**************************************************************************/
/* FUNCTION     : flexCAN_C_config		  								  */
/* PURPOSE      : Configures FlexCAN A & buffers						  */
/**************************************************************************/
void flexCAN_C_config(void){
	
	int i=0;
	int j=0;
	
	/* Turn on CAN_A*/
	CAN_C.MCR.R = 0x1080000F;

	/* Initialize all operating modes for CAN_A*/
	CAN_C.CR.R = 0x0f492002;

	/* Initialize all CAN_A message buffers as inactive */
	CAN_C.BUF[2].CS.B.CODE = 0x8;
	CAN_C.BUF[3].CS.B.CODE = 0x4;

	for (i=4; i<16; i++)
	{
		CAN_C.BUF[i].CS.B.CODE = 0x0;
	}

	/* Set transmit length of CAN_A[0] and CAN_A[2] to 8 bytes */
	CAN_C.BUF[2].CS.B.LENGTH = 0x8;
	CAN_C.BUF[3].CS.B.LENGTH = 0x8;

	/* Set MB IDE, RTR, and IDs for CAN_A */
	CAN_C.BUF[2].CS.B.IDE = 0;
	CAN_C.BUF[3].CS.B.IDE = 0;

	CAN_C.BUF[2].CS.B.RTR = 0;
	CAN_C.BUF[3].CS.B.RTR = 0;

	CAN_C.BUF[2].ID.R = 0x09000000;
	CAN_C.BUF[3].ID.R = 0x11000000;

	CAN_C.RXGMASK.R = 0x1FFFFFFF;
	/* Negate halt bit in MCR to synch with FlexCAN bus */
	CAN_C.MCR.B.HALT = 0;

	CAN_C.BUF[3].DATA.W[0] = 0x00000000;
	CAN_C.BUF[3].DATA.W[1] = 0x00000000;

}


/********************************************************************/